/*
 * Decompiled with CFR 0.152.
 */
package com.oxaion.tools.weblauncher.data;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class Repository {
    public static final String DEFAULT_ACCESSOR = "/currentversions.xml";
    private String path;
    private String accessor = "/currentversions.xml";
    private List<Pattern> excludes = new ArrayList<Pattern>();

    public void addExclude(String regex) {
        this.excludes.add(Pattern.compile(regex));
    }

    public boolean isExcluded(String fileName, String clientOS) {
        for (Pattern pattern : this.excludes) {
            if (!pattern.matcher(fileName).find(0)) continue;
            return true;
        }
        boolean mac = clientOS.startsWith("mac");
        boolean linux = clientOS.startsWith("linux");
        if (fileName.equals("jre")) {
            return linux || mac;
        }
        if (fileName.startsWith("jxbrowser-linux")) {
            return !linux;
        }
        if (fileName.startsWith("jxbrowser-mac")) {
            return !mac;
        }
        if (fileName.startsWith("jxbrowser-win")) {
            return linux || mac;
        }
        if (fileName.startsWith("javafx-") && fileName.endsWith("-win.jar")) {
            return linux || mac;
        }
        if (fileName.startsWith("javafx-") && fileName.endsWith("-mac.jar")) {
            return !mac;
        }
        return false;
    }

    public String getAccessor() {
        return this.accessor;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        this.path = string;
    }
}

